#!/bin/bash

# ========================================
# Pi Technology Remote - Installazione Automatica
# ========================================

# Password casuale
rustdesk_pw=$(openssl rand -hex 6)

# Configurazione server Pi Technology
rustdesk_server="rust.aswell.eu"
rustdesk_key="K62PSpdHPvA3sEl+eywB0R6RCx5+8yMRqp9xHwkJ1ck="

echo "========================================"
echo "Pi Technology Remote - Installazione"
echo "========================================"
echo ""

# Richiedi privilegi root
if [ "$EUID" -ne 0 ]; then
    echo "Questo script richiede privilegi root"
    exec sudo bash "$0" "$@"
fi

# Rileva distribuzione
if [ -f /etc/os-release ]; then
    . /etc/os-release
    OS=$ID
else
    echo "Impossibile rilevare la distribuzione"
    exit 1
fi

echo "Distribuzione rilevata: $OS"
echo "Download RustDesk..."

# Crea directory temporanea
mkdir -p /tmp/rustdesk-install
cd /tmp/rustdesk-install

# Ottieni l'ultima versione
latest_version=$(curl -sL https://api.github.com/repos/rustdesk/rustdesk/releases/latest | grep '"tag_name"' | sed -E 's/.*"([^"]+)".*/\1/')

if [ -z "$latest_version" ]; then
    echo "✗ Impossibile ottenere l'ultima versione"
    exit 1
fi

echo "Versione rilevata: $latest_version"

# Download basato sulla distribuzione
case "$OS" in
    ubuntu|debian|linuxmint|pop)
        echo "Installazione per Debian/Ubuntu..."
        deb_file="rustdesk-${latest_version}-x86_64.deb"
        rd_link="https://github.com/rustdesk/rustdesk/releases/download/${latest_version}/${deb_file}"
        
        echo "Download da: $rd_link"
        curl -L "$rd_link" --output "$deb_file"
        
        if [ ! -f "$deb_file" ]; then
            echo "✗ Download fallito"
            exit 1
        fi
        
        echo "Installazione pacchetto..."
        dpkg -i "$deb_file"
        apt-get install -f -y
        ;;
        
    fedora|rhel|centos|rocky|alma)
        echo "Installazione per Fedora/RHEL..."
        rpm_file="rustdesk-${latest_version}-x86_64.rpm"
        rd_link="https://github.com/rustdesk/rustdesk/releases/download/${latest_version}/${rpm_file}"
        
        echo "Download da: $rd_link"
        curl -L "$rd_link" --output "$rpm_file"
        
        if [ ! -f "$rpm_file" ]; then
            echo "✗ Download fallito"
            exit 1
        fi
        
        echo "Installazione pacchetto..."
        rpm -i "$rpm_file"
        ;;
        
    arch|manjaro)
        echo "Installazione per Arch Linux..."
        echo "Usa AUR: yay -S rustdesk"
        echo "Oppure scarica manualmente da GitHub"
        exit 1
        ;;
        
    *)
        echo "Distribuzione non supportata automaticamente"
        echo "Scarica manualmente da: https://github.com/rustdesk/rustdesk/releases/latest"
        exit 1
        ;;
esac

if [ $? -eq 0 ]; then
    echo "✓ RustDesk installato"
else
    echo "✗ Errore durante l'installazione"
    exit 1
fi

echo "Configurazione server Pi Technology..."

# Crea directory di configurazione
config_dir="$HOME/.config/rustdesk"
mkdir -p "$config_dir"

# Crea file di configurazione
cat > "$config_dir/RustDesk2.toml" << EOF
rendezvous_server = '$rustdesk_server'
nat_type = 1
serial = 0

[options]
custom-rendezvous-server = '$rustdesk_server'
key = '$rustdesk_key'
relay-server = '$rustdesk_server'
api-server = ''
EOF

echo "✓ Configurazione creata in: $config_dir/RustDesk2.toml"

# Avvia il servizio
echo "Avvio servizio RustDesk..."
systemctl enable rustdesk 2>/dev/null
systemctl start rustdesk 2>/dev/null

# Avvia RustDesk per generare ID
rustdesk --server &
sleep 3

# Ottieni ID
rustdesk_id=$(rustdesk --get-id 2>/dev/null)

# Imposta password
rustdesk --password $rustdesk_pw 2>/dev/null

# Termina processi temporanei
sleep 1
pkill -f rustdesk 2>/dev/null

echo ""
echo "========================================"
echo "INSTALLAZIONE COMPLETATA!"
echo "========================================"
echo ""
echo "Server: $rustdesk_server"
echo "RustDesk ID: $rustdesk_id"
echo "Password: $rustdesk_pw"
echo ""
echo "Comunica questi dati a chi deve connettersi"
echo "========================================"
echo ""

# Pulizia
cd /
rm -rf /tmp/rustdesk-install

echo "Installazione completata!"
