#!/bin/bash

echo "========================================"
echo "RustDesk Client - Configurazione Server"
echo "========================================"
echo ""
echo "Server: rust.aswell.eu"
echo ""

# Directory di configurazione RustDesk su Linux
CONFIG_DIR="$HOME/.config/rustdesk"

# Crea la directory se non esiste
if [ ! -d "$CONFIG_DIR" ]; then
    mkdir -p "$CONFIG_DIR"
    echo "Directory di configurazione creata: $CONFIG_DIR"
fi

# Copia il file di configurazione
cp RustDesk2.toml "$CONFIG_DIR/RustDesk2.toml"
echo "Configurazione copiata in: $CONFIG_DIR/RustDesk2.toml"

echo ""
echo "Avvio RustDesk..."

# Verifica se RustDesk è installato
if command -v rustdesk &> /dev/null; then
    rustdesk &
    echo "RustDesk avviato!"
else
    echo "ATTENZIONE: RustDesk non trovato nel PATH"
    echo "Installa RustDesk prima di eseguire questo script:"
    echo ""
    echo "Ubuntu/Debian:"
    echo "  sudo dpkg -i rustdesk-*.deb"
    echo ""
    echo "Fedora/RHEL:"
    echo "  sudo rpm -i rustdesk-*.rpm"
    echo ""
    echo "AppImage:"
    echo "  chmod +x rustdesk-*.AppImage"
    echo "  ./rustdesk-*.AppImage"
fi

echo ""
echo "Configurazione completata!"
echo "Premi INVIO per chiudere..."
read
